/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class VerticalHalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstDividedStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstDoubleSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> VerticalHalfStairsSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalDividedStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstStackedSlopeSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatStackedSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatStackedInnerSlopeSlabCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> VerticalHalfStairsSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> VerticalHalfStairsSkipPredicate.testAgainstVerticalDoubleHalfSlope(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstSlopedStairs(level, pos, state, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (VerticalHalfStairsSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (VerticalHalfStairsSkipPredicate.getStairDir(dir, top, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getCornerDir(dir, top, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (VerticalHalfStairsSkipPredicate.getStairDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getStairDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (VerticalHalfStairsSkipPredicate.getCornerDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatStackedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) != SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalHalfStairsSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static TriangleDir getStairDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return TriangleDir.fromDirections(dir, dir.m_122428_());
        }
        return TriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean top, Direction side) {
        if (side == dir || side == dir.m_122428_()) {
            return HalfDir.fromDirections(side, top ? Direction.UP : Direction.DOWN);
        }
        return HalfDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, boolean top, Direction side) {
        if (side == dir.m_122427_()) {
            return CornerDir.fromDirections(side, dir, top ? Direction.UP : Direction.DOWN);
        }
        if (side == dir.m_122424_()) {
            return CornerDir.fromDirections(side, dir.m_122428_(), top ? Direction.UP : Direction.DOWN);
        }
        return CornerDir.NULL;
    }
}

